﻿namespace RemiseANiveau2.Models
{


    /// <summary>
    /// Classe contenant les informations issues d'un modèle de VersionIndex.
    /// </summary>
    public class VersionExercicesViewModel
    {
        /// <summary>
        /// Obtient ou definit le premier élément de la liste des versions sous un objet anonyme.
        /// </summary>
        public string Anon { get; set; }

        /// <summary>
        /// Obtient ou definit la liste des versions ordonnés par leur numéro et leur date.
        /// </summary>
        public List<Entities.Version> OrderBy { get; set; }

        /// <summary>
        /// Obtient ou definit la liste des versions ordonnés par leur numéro.
        /// </summary>
        public List<Entities.Version> OrderByNum { get; set; }

        /// <summary>
        /// Obtient ou definit les versions après le 5èeme élément de la liste des versions.
        /// </summary>
        public List<Entities.Version> Après5eme {  get; set; }

        /// <summary>
        /// Obtient ou definit la dernière version de la liste.
        /// </summary>
        public string Last { get; set; }

        /// <summary>
        /// Obtient ou definit la première version de la liste.
        /// </summary>
        public string Premier{  get; set; }

        /// <summary>
        /// Obtient ou définit le nombre de version.
        /// </summary>
        public int Count { get; set; }

        /// <summary>
        /// Obtient ou créer une liste de versions.
        /// </summary>
        public List<Entities.Version> Versions { get; set; }
    }
}